#version unofficial MegaPov 0.4;

//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 19 materials and 310 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/29/2000    (29.02.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  #declare high_quality=no; // or yes
#if(high_quality)
  // High Quality - slow rendering
  ini_option "+QR"
  ini_option "Preview_Start_Size=8"
  ini_option "Preview_End_Size=4"
  
  radiosity{
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16 (or 8 for high quality)
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#else
  // Medium Quality - works for most scenes
  ini_option "+QR"
  ini_option "Preview_Start_Size=16"
  ini_option "Preview_End_Size=8"
  
  radiosity{
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 2.25     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#end

}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera02
  location  <    -14.500,      -8.100,       1.050>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38535,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         56.09889    // Vertical      42.074
  look_at   <     -5.103,       2.634,      13.750>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera01
  location  <    -40.889,     -29.581,      24.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34708,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00984    // Vertical      22.507
  look_at   <     -4.151,       6.826,       6.374>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale 100.0
  rotate <88.0, 0.0, -7.0>
  translate  <-454.0, -1935.0, 280.85>
}



//
// ********  MATERIALS  *******
//

#include "sarcophagus 2.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare CSG016 = difference {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  1.65*z
}
#declare CSG017 = difference {
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  3.0*z
}
#declare CSG018 = difference {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  4.85*z
}
#declare CSG019 = difference {
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  6.0*z
}
#declare CSG020 = difference {
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  7.7*z
}
#declare CSG021 = difference {
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  9.0*z
}
#declare CSG022 = difference {
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
  translate  10.65*z
}
#declare CSG001 = difference {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    rotate 90.0*x
    translate  <7.3, -0.95, 2.65>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.135, 2.0>
    rotate 90.0*x
    translate  <7.3, -0.8, 2.65>
  }
}
#declare CSG023 = union {
  object { CSG016 }
  object { CSG017 }
  object { CSG018 }
  object { CSG019 }
  object { CSG020 }
  object { CSG021 }
  object { CSG022 }
  object { CSG001 }
  material {
    Dark
  }
  translate  0.02*y
}


#declare Braces_2 = union {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.0, -1.0>
    material {
      New_Brace
      translate <0.000000, -0.050000, -2.000000>
    }
    scale <0.15, 1.0, 4.5>
    rotate <-5.0, -0.0, -0.0>
    translate  <9.25, -1.35, 9.0>
  }
  scale 0.4
  rotate -90.0*z
  translate  <-9.65, 7.2, 9.95>
}


#declare Holes_Row_1 = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 10.35>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 4.3>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 8.65>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 5.65>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 7.5>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 2.65>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 11.65>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Rivet
      rotate <0.0, 0.0, -0.0>
    }
    scale <0.15, 0.15, 0.2>
    rotate 90.0*x
    translate  <7.3, -0.85, 13.3>
  }
}


#declare Cube018 = object {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      Top_Peg
      translate <0.050000, 0.000000, -0.950000>
    }
    scale 0.1
    translate  <8.0, -0.95, 14.1>
  }
}


#declare Cylndr120 = object {
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.01, 0.01, 0.5>
    translate  <9.5, -1.0, 14.0>
  }
}
#declare Cylndr077 = object {
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.01, 0.01, 0.5>
    translate  <10.0, -1.0, 14.0>
  }
}
#declare Cylndr097 = object {
  object { // Cylndr097->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -20.0*x
  }
}


#declare Cube002 = object {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.0, -1.0>
    material {
      New_Brace
      translate <0.000000, 0.050000, -1.000000>
    }
    scale <0.15, 1.0, 4.5>
    rotate <-5.0, -0.0, -0.0>
    translate  <8.0, -1.35, 9.0>
  }
}


#declare Group011 = union {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.025, 0.075>
    translate  <-9.5, -2.0, 0.5>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.414214>
    rotate -45.0*y
    translate  <-9.0, -2.0, 0.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.414214>
    rotate 45.0*y
    translate  <-10.0, -2.0, 0.0>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.035, 0.035, 1.0>
    rotate -90.0*y
    translate  <-9.0, -2.0, 1.0>
  }
  material {
    Rivet
  }
}
#declare Group013 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.065, 0.065, 0.2>
    translate  <-10.0, -2.0, 0.9>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.025, 0.075>
    translate  <-9.5, -2.0, 0.5>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.414214>
    rotate -45.0*y
    translate  <-9.0, -2.0, 0.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.414214>
    rotate 45.0*y
    translate  <-10.0, -2.0, 0.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.035, 0.035, 1.0>
    rotate -90.0*y
    translate  <-9.0, -2.0, 1.0>
  }
  rotate -0.0*z
  translate  <10.0, 2.0, 0.0>
  material {
    Rivet
  }
  rotate 90.0*z
  translate  <-10.0, -2.0, 0.0>
}
#declare Group014 = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.065, 0.065, 0.2>
    translate  <-10.0, -2.0, 0.9>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.025, 0.075>
    translate  <-9.5, -2.0, 0.5>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.035, 0.035, 1.414214>
    rotate -45.0*y
    translate  <-9.0, -2.0, 0.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.035, 0.035, 1.414214>
    rotate 45.0*y
    translate  <-10.0, -2.0, 0.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.035, 0.035, 1.0>
    rotate -90.0*y
    translate  <-9.0, -2.0, 1.0>
  }
  rotate -0.0*z
  translate  <10.0, 2.0, 0.0>
  material {
    Rivet
  }
  rotate 90.0*z
  translate  <-9.0, -2.0, 0.0>
}
#declare Group015 = union {
  object { Group011 }
  object { Group013 }
  object { Group014 }
}
#declare Extra_Rings = union {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.065, 0.065, 0.2>
    translate  <-10.0, -1.0, 0.9>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.065, 0.065, 0.2>
    translate  <-9.0, -1.0, 0.9>
  }
}


#declare Group036 = union {
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.45, 0.45, 45.0>
    rotate <167.927795, -0.524811, 22.451309>
    translate  <4.5, -12.0, -56.0>
  }
}
#declare Group037 = union {
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.25, 0.25, 16.0>
    rotate <0.0, -21.0, -0.0>
    translate  <0.0, -21.5, -82.5>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.25, 0.25, 16.0>
    rotate <-0.0, 21.0, -0.0>
    translate  <0.0, -21.5, -82.5>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.25, 0.25, 13.8>
    rotate <-0.0, 24.5, -0.0>
    translate  <-5.7, -21.5, -67.6>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.25, 0.25, 13.8>
    rotate <-0.0, -24.5, -0.0>
    translate  <5.7, -21.5, -67.6>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.2, 0.2, 19.25>
    rotate <-0.0, -26.0, -0.0>
    translate  <8.4, -21.5, -99.9>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.25, 0.25, 19.25>
    rotate <-0.0, 26.0, -0.0>
    translate  <-8.4, -21.5, -99.9>
  }
  rotate 0.0*x
  translate  <-0.0, 21.536196, 100.0472>
  rotate -11.0*x
  translate  <0.2, -20.7, -100.2>
}
#declare Tilty_Girders = union {
  object { Group036 }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.3, 0.3, 14.0>
    rotate <90.0, 23.0, 90.0>
    translate  <-7.0, -17.2, -82.9>
  }
  object { Group037 }
  rotate -23.0*x
  translate  <0.0, 60.817623, 88.25229>
  rotate 23.0*x
  translate  <0.0, -21.3, -104.6>
}
#declare Tilty_Girder_Group = union {
  object { Tilty_Girders }
}
#declare Group045 = union {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <0.15, 0.15, 24.0>
    rotate <90.0, -0.0, 90.0>
    translate  <-12.0, -12.0, -76.3>
  }
}
#declare Cylndr033 = object {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.1, 0.1, 2.5>
    translate  <-3.0, -12.0, 0.0>
  }
}
#declare Railing_9 = union {
  object { // Cylndr030->Cylndr033
    Cylndr033
    rotate -0.0*z
    translate  <6.0, -0.0, 0.0>
  }
  object { // Cylndr031->Cylndr033
    Cylndr033
    rotate -0.0*z
    translate  <4.0, -0.0, 0.0>
  }
  object { // Cylndr032->Cylndr033
    Cylndr033
    rotate -0.0*z
    translate  <2.0, -0.0, 0.0>
  }
  object { Cylndr033 }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.06, 0.075, 10.0>
    rotate 90.0*y
    translate  <-5.1, -12.0, 2.5>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.06, 0.075, 10.0>
    rotate 90.0*y
    translate  <-5.1, -12.0, 1.1>
  }
  translate  -76.0*z
}
#declare Cylndr017 = object {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.1, 0.1, 2.5>
    translate  <-3.0, -12.0, 0.0>
  }
}
#declare Railing_1 = union {
  object { // Cylndr016->Cylndr017
    Cylndr017
    rotate -0.0*z
    translate  <6.0, -0.0, 0.0>
  }
  object { // Cylndr015->Cylndr017
    Cylndr017
    rotate -0.0*z
    translate  <4.0, -0.0, 0.0>
  }
  object { // Cylndr014->Cylndr017
    Cylndr017
    rotate -0.0*z
    translate  <2.0, -0.0, 0.0>
  }
  object { Cylndr017 }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.06, 0.075, 10.0>
    rotate 90.0*y
    translate  <-5.1, -12.0, 2.5>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.06, 0.075, 10.0>
    rotate 90.0*y
    translate  <-5.1, -12.0, 1.1>
  }
  translate  <0.1, 0.5, 0.0>
}
#include "C:\Simon\IRTC - Ruins\platform.inc"

#declare Object1_Ref = object {
  Object1
  translate  <-0.1, 0.0, 0.75>
}
#declare UserDefGroup1 = union {
  object { Object1_Ref }
  material {
    White
  }
  translate  -0.75*z
}
#declare Girders = union {
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 1.0>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 3.0>
    translate  <5.0, -12.0, 6.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate 35.0*y
    translate  -12.0*y
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 15.0>
    translate  <5.0, -12.0, 0.0>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate -35.0*y
    translate  -12.0*y
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate <180.0, 35.0, 180.0>
    translate  <0.0, -12.0, 15.0>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate <180.0, -35.0, 180.0>
    translate  <0.0, -12.0, 15.0>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 14.0>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 9.0>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 5.9>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.06, 0.075, 10.0>
    rotate 90.0*y
    translate  <-5.0, -12.0, 7.44>
  }
  rotate 0.0*z
  translate  -0.0*x
  material {
    White
  }
  scale <1.0, 1.0, 1.25>
}
#declare Floor_1 = union {
  object { // Railing_8->Railing 1
    Railing_1
    rotate 45.0*z
    translate  <0.382843, 0.075736, 0.0>
  }
  object { // Railing_7->Railing 1
    Railing_1
    rotate 90.0*z
    translate  <0.6, 0.4, 0.0>
  }
  object { // Railing_6->Railing 1
    Railing_1
    rotate 135.0*z
    translate  <0.524264, 0.782843, 0.0>
  }
  object { // Railing_5->Railing 1
    Railing_1
    rotate -180.0*z
    translate  <0.2, 1.0, 0.0>
  }
  object { // Railing_4->Railing 1
    Railing_1
    rotate -135.0*z
    translate  <-0.182843, 0.924264, 0.0>
  }
  object { // Railing_3->Railing 1
    Railing_1
    rotate -90.0*z
    translate  <-0.4, 0.6, 0.0>
  }
  object { // Railing_2->Railing 1
    Railing_1
    rotate -45.0*z
    translate  <-0.324264, 0.217157, 0.0>
  }
  object { Railing_1 }
  object { UserDefGroup1 }
  object { // CSG008->Girders
    Girders
    rotate 45.0*z
  }
  object { // CSG007->Girders
    Girders
    rotate 90.0*z
  }
  object { // CSG006->Girders
    Girders
    rotate 135.0*z
  }
  object { // CSG005->Girders
    Girders
    rotate -180.0*z
  }
  object { // CSG004->Girders
    Girders
    rotate -135.0*z
  }
  object { // CSG003->Girders
    Girders
    rotate -90.0*z
  }
  object { // CSG002->Girders
    Girders
    rotate -45.0*z
  }
  object { Girders }
}
#declare Girders1 = union {
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 1.0>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 3.0>
    translate  <5.0, -12.0, 6.0>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate 35.0*y
    translate  -12.0*y
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 15.0>
    translate  <5.0, -12.0, 0.0>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate -35.0*y
    translate  -12.0*y
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate <180.0, 35.0, 180.0>
    translate  <0.0, -12.0, 15.0>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 8.5>
    rotate <180.0, -35.0, 180.0>
    translate  <0.0, -12.0, 15.0>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 14.0>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 9.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.6, 0.6, 0.1>
    translate  <5.0, -12.0, 5.9>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.06, 0.075, 10.0>
    rotate 90.0*y
    translate  <-5.0, -12.0, 7.44>
  }
  rotate 0.0*z
  translate  -0.0*x
  material {
    White
  }
  scale <1.0, 1.0, 1.25>
}
#declare Cylndr071 = object {
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      Red_Stripe
      translate <-0.100000, 0.000000, 0.000000>
    }
    scale <7.5, 7.5, 9.35>
  }
}




//
// ********  OBJECTS  *******
//

box { // Cube022
  <-1, -1, -1>, <1, 1, 1>
  material {
    GreyMBlue_Paint_Filler
  }
  scale <0.51, 2.1, 0.05>
  translate  <-10.525, 1.075, 12.0>
}




union { // Wall_Rings
  object { // CSG030->CSG023
    CSG023
    translate  -14.0*x
  }
  object { // CSG029->CSG023
    CSG023
    translate  -12.0*x
  }
  object { // CSG028->CSG023
    CSG023
    translate  -10.0*x
  }
  object { // CSG027->CSG023
    CSG023
    translate  -8.0*x
  }
  object { // CSG026->CSG023
    CSG023
    translate  -6.0*x
  }
  object { // CSG025->CSG023
    CSG023
    translate  -4.0*x
  }
  object { // CSG024->CSG023
    CSG023
    translate  -2.0*x
  }
  object { CSG023 }
}


union { // Side_Braces
  object { // Braces_9->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 14.0, -0.0>
  }
  object { // Braces_8->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 12.0, -0.0>
  }
  object { // Braces_7->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 10.0, -0.0>
  }
  object { // Braces_6->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 8.0, -0.0>
  }
  object { // Braces_5->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 6.0, -0.0>
  }
  object { // Braces_4->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 4.0, -0.0>
  }
  object { // Braces_3->Braces 2
    Braces_2
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 2.0, -0.0>
  }
  object { Braces_2 }
}


#declare Front_Wall = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.2, 7.0>
    translate  <0.0, -0.799, 7.0>
  }
  material {
    Yet_Another_New_Grid
    translate <10.150000, 0.000000, -0.050000>
  }
}
#declare All_Holes = union {
  object { // Holes_Row_8->Holes Row 1
    Holes_Row_1
    translate  -14.0*x
  }
  object { // Holes_Row_7->Holes Row 1
    Holes_Row_1
    translate  -12.0*x
  }
  object { // Holes_Row_6->Holes Row 1
    Holes_Row_1
    translate  -10.0*x
  }
  object { // Holes_Row_5->Holes Row 1
    Holes_Row_1
    translate  -8.0*x
  }
  object { // Holes_Row_4->Holes Row 1
    Holes_Row_1
    translate  -6.0*x
  }
  object { // Holes_Row_3->Holes Row 1
    Holes_Row_1
    translate  -4.0*x
  }
  object { // Holes_Row_2->Holes Row 1
    Holes_Row_1
    translate  -2.0*x
  }
  object { Holes_Row_1 }
  translate  -0.1*y
}
difference { // Front_wall_with_holes
  object { Front_Wall }
  object { All_Holes }
}


union { // Top_Pegs
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreyMBlue_Paint_Filler
    }
    scale <20.0, 20.0, 0.01>
    translate  <9.975, 18.975, 14.0>
  }
  object { // Cube031->Cube018
    Cube018
    translate  <-16.0, 0.0, -0.0>
  }
  object { // Cube030->Cube018
    Cube018
    translate  <-14.0, 0.0, -0.0>
  }
  object { // Cube029->Cube018
    Cube018
    translate  <-12.0, 0.0, -0.0>
  }
  object { // Cube028->Cube018
    Cube018
    translate  <-10.0, 0.0, -0.0>
  }
  object { // Cube027->Cube018
    Cube018
    translate  <-8.0, 0.0, -0.0>
  }
  object { // Cube021->Cube018
    Cube018
    translate  <-6.0, 0.0, -0.0>
  }
  object { // Cube020->Cube018
    Cube018
    translate  <-4.0, 0.0, -0.0>
  }
  object { // Cube019->Cube018
    Cube018
    translate  <-2.0, 0.0, -0.0>
  }
  object { Cube018 }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreyMBlue_Paint_Filler
    }
    scale <0.3, 20.0, 0.3>
    translate  <9.7, 18.8, 14.3>
  }
}


union { // Fence
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreyMBlue_Paint_Filler
    }
    scale <0.2, 0.6, 0.01>
    translate  <-9.0, -1.55, 14.1>
  }
  object { // Cylndr139->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-19.0, -0.0, 0.0>
  }
  object { // Cylndr138->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-18.0, -0.0, 0.0>
  }
  object { // Cylndr137->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-17.0, -0.0, 0.0>
  }
  object { // Cylndr136->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-16.0, -0.0, 0.0>
  }
  object { // Cylndr135->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-15.0, -0.0, 0.0>
  }
  object { // Cylndr134->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-14.0, -0.0, 0.0>
  }
  object { // Cylndr133->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-13.0, -0.0, 0.0>
  }
  object { // Cylndr132->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-12.0, -0.0, 0.0>
  }
  object { // Cylndr131->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-11.0, -0.0, 0.0>
  }
  object { // Cylndr130->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-10.0, -0.0, 0.0>
  }
  object { // Cylndr129->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-9.0, -0.0, 0.0>
  }
  object { // Cylndr128->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-8.0, -0.0, 0.0>
  }
  object { // Cylndr127->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-7.0, -0.0, 0.0>
  }
  object { // Cylndr126->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-6.0, -0.0, 0.0>
  }
  object { // Cylndr125->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-5.0, -0.0, 0.0>
  }
  object { // Cylndr124->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-4.0, -0.0, 0.0>
  }
  object { // Cylndr123->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-3.0, -0.0, 0.0>
  }
  object { // Cylndr122->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-2.0, -0.0, 0.0>
  }
  object { // Cylndr121->Cylndr120
    Cylndr120
    rotate 0.0*y
    translate  <-1.0, -0.0, 0.0>
  }
  object { // Cylndr118->Cylndr097
    Cylndr097
    translate  20.0*y
  }
  object { // Cylndr117->Cylndr097
    Cylndr097
    translate  19.0*y
  }
  object { // Cylndr116->Cylndr097
    Cylndr097
    translate  18.0*y
  }
  object { // Cylndr115->Cylndr097
    Cylndr097
    translate  17.0*y
  }
  object { // Cylndr114->Cylndr097
    Cylndr097
    translate  16.0*y
  }
  object { // Cylndr113->Cylndr097
    Cylndr097
    translate  15.0*y
  }
  object { // Cylndr112->Cylndr097
    Cylndr097
    translate  14.0*y
  }
  object { // Cylndr111->Cylndr097
    Cylndr097
    translate  13.0*y
  }
  object { // Cylndr110->Cylndr097
    Cylndr097
    translate  12.0*y
  }
  object { // Cylndr109->Cylndr097
    Cylndr097
    translate  11.0*y
  }
  object { // Cylndr108->Cylndr097
    Cylndr097
    translate  10.0*y
  }
  object { // Cylndr107->Cylndr097
    Cylndr097
    translate  9.0*y
  }
  object { // Cylndr106->Cylndr097
    Cylndr097
    translate  8.0*y
  }
  object { // Cylndr105->Cylndr097
    Cylndr097
    translate  7.0*y
  }
  object { // Cylndr104->Cylndr097
    Cylndr097
    translate  6.0*y
  }
  object { // Cylndr103->Cylndr097
    Cylndr097
    translate  5.0*y
  }
  object { // Cylndr102->Cylndr097
    Cylndr097
    translate  4.0*y
  }
  object { // Cylndr101->Cylndr097
    Cylndr097
    translate  3.0*y
  }
  object { // Cylndr100->Cylndr097
    Cylndr097
    translate  2.0*y
  }
  object { // Cylndr099->Cylndr097
    Cylndr097
    translate  1.0*y
  }
  object { Cylndr097 }
  object { // Cylndr096->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -19.0*x
  }
  object { // Cylndr095->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -18.0*x
  }
  object { // Cylndr094->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -17.0*x
  }
  object { // Cylndr093->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -16.0*x
  }
  object { // Cylndr092->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -15.0*x
  }
  object { // Cylndr091->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -14.0*x
  }
  object { // Cylndr090->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -13.0*x
  }
  object { // Cylndr088->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -11.0*x
  }
  object { // Cylndr089->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -12.0*x
  }
  object { // Cylndr086->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -9.0*x
  }
  object { // Cylndr085->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -8.0*x
  }
  object { // Cylndr084->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -7.0*x
  }
  object { // Cylndr083->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -6.0*x
  }
  object { // Cylndr082->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -5.0*x
  }
  object { // Cylndr081->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -4.0*x
  }
  object { // Cylndr080->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -3.0*x
  }
  object { // Cylndr087->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -10.0*x
  }
  object { // Cylndr079->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -2.0*x
  }
  object { // Cylndr078->Cylndr077
    Cylndr077
    rotate <0.0, -0.0, -0.0>
    translate  -1.0*x
  }
  object { Cylndr077 }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.01, 0.01, 20.0>
    rotate -90.0*y
    translate  <10.0, -1.0, 14.45>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    material {
      Wire
    }
    scale <0.01, 0.01, 20.0>
    rotate <-90.0, 0.0, -0.0>
    translate  <-10.0, -1.0, 14.45>
  }
  object { Cylndr120 }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreyMBlue_Paint_Filler
    }
    scale <0.2, 0.2, 0.01>
    translate  <-9.2, -1.15, 14.1>
  }
}


union { // Braces_1
  object { // Cube010->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -16.0*x
  }
  object { // Cube009->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -14.0*x
  }
  object { // Cube008->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -12.0*x
  }
  object { // Cube007->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -10.0*x
  }
  object { // Cube006->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -8.0*x
  }
  object { // Cube005->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -6.0*x
  }
  object { // Cube004->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -4.0*x
  }
  object { // Cube003->Cube002
    Cube002
    rotate <0.0, -0.0, 0.0>
    translate  -2.0*x
  }
  object { Cube002 }
}


union { // Group012
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      Bricks
      scale <0.66, 0.5, 0.166667>
      translate <-0.300000, -0.550000, 0.500000>
    }
    scale <1.5, 2.0, 6.0>
    translate  <-9.5, 0.0, 6.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      Bricks
      scale <5.0, 0.1, 0.143>
      translate <-0.800000, -0.910000, 0.250000>
    }
    scale <0.2, 10.0, 7.0>
    translate  <-9.8, 8.05, 7.3>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      Bricks
      scale <2.0, 0.1, 0.2>
      translate <0.000000, -0.905000, -1.200000>
    }
    scale <0.5, 10.0, 5.0>
    translate  <-10.0, 8.05, 5.0>
  }
  material {
    Bricks
  }
  translate  1.0*y
}


plane { // Plane001
  z,0
  material {
    Black
  }
}




#declare Group001 = union {
  object { // Extra_Rings13->Extra Rings
    Extra_Rings
    translate  13.0*z
  }
  object { // Extra_Rings12->Extra Rings
    Extra_Rings
    translate  12.0*z
  }
  object { // Extra_Rings11->Extra Rings
    Extra_Rings
    translate  11.0*z
  }
  object { // Extra_Rings10->Extra Rings
    Extra_Rings
    translate  10.0*z
  }
  object { // Extra_Rings9->Extra Rings
    Extra_Rings
    translate  9.0*z
  }
  object { // Extra_Rings8->Extra Rings
    Extra_Rings
    translate  8.0*z
  }
  object { // Extra_Rings7->Extra Rings
    Extra_Rings
    translate  7.0*z
  }
  object { // Extra_Rings6->Extra Rings
    Extra_Rings
    translate  6.0*z
  }
  object { // Extra_Rings5->Extra Rings
    Extra_Rings
    translate  5.0*z
  }
  object { // Extra_Rings4->Extra Rings
    Extra_Rings
    translate  4.0*z
  }
  object { // Extra_Rings3->Extra Rings
    Extra_Rings
    translate  3.0*z
  }
  object { // Extra_Rings2->Extra Rings
    Extra_Rings
    translate  2.0*z
  }
  object { // Extra_Rings1->Extra Rings
    Extra_Rings
    translate  1.0*z
  }
  object { Extra_Rings }
}
union { // Edge_Scaffolding
  object { // Group028->Group015
    Group015
    translate  13.0*z
  }
  object { // Group027->Group015
    Group015
    translate  12.0*z
  }
  object { // Group026->Group015
    Group015
    translate  11.0*z
  }
  object { // Group025->Group015
    Group015
    translate  10.0*z
  }
  object { // Group024->Group015
    Group015
    translate  9.0*z
  }
  object { // Group023->Group015
    Group015
    translate  8.0*z
  }
  object { // Group022->Group015
    Group015
    translate  7.0*z
  }
  object { // Group021->Group015
    Group015
    translate  6.0*z
  }
  object { // Group020->Group015
    Group015
    translate  5.0*z
  }
  object { // Group019->Group015
    Group015
    translate  4.0*z
  }
  object { // Group018->Group015
    Group015
    translate  3.0*z
  }
  object { // Group017->Group015
    Group015
    translate  2.0*z
  }
  object { // Group016->Group015
    Group015
    translate  1.0*z
  }
  object { Group015 }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Pipe
      scale <1.0, 1.0, 0.0715>
    }
    scale <0.05, 0.05, 14.0>
    translate  <-9.0, -2.0, 0.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Pipe
      scale <1.0, 1.0, 0.0715>
      translate <0.000000, -10.050000, 0.000000>
    }
    scale <0.05, 0.05, 14.0>
    translate  <-10.0, -2.0, 0.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Pipe
      scale <1.0, 1.0, 0.0715>
      translate <0.000000, -10.050000, 0.000000>
    }
    scale <0.05, 0.05, 14.0>
    translate  <-10.0, -1.0, 0.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Pipe
      scale <1.0, 1.0, 0.0715>
      translate <0.000000, -10.050000, 0.000000>
    }
    scale <0.05, 0.05, 14.0>
    translate  <-9.0, -1.0, 0.0>
  }
  object { Group001 }
}


sphere { // Sky_Sphere
  <0,0,0>,1
  material {
    Sky
  }
  hollow
  scale 10000.0
  rotate -90.0*z
  translate  <-2.7, 0.0, 0.3>
}


#declare Star_Girders = union {
  object { // Group038->Group045
    Group045
    rotate 45.0*z
  }
  object { // Group039->Group045
    Group045
    rotate 90.0*z
  }
  object { // Group040->Group045
    Group045
    rotate 135.0*z
  }
  object { // Group041->Group045
    Group045
    rotate -180.0*z
  }
  object { // Group042->Group045
    Group045
    rotate -135.0*z
  }
  object { // Group043->Group045
    Group045
    rotate -90.0*z
  }
  object { // Group044->Group045
    Group045
    rotate -45.0*z
  }
  object { Group045 }
  translate  <-0.2, 0.0, -6.2>
}
#declare Object2_Ref = object {
  Object1
  translate  <-0.1, 0.0, 0.75>
}
#declare UserDefGroup2 = union {
  object { Object2_Ref }
  material {
    White
  }
  translate  -76.8*z
}
#declare Bottom_Floor = union {
  object { // Railing_16->Railing 9
    Railing_9
    rotate 45.0*z
  }
  object { // Railing_15->Railing 9
    Railing_9
    rotate 90.0*z
  }
  object { // Railing_14->Railing 9
    Railing_9
    rotate 135.0*z
  }
  object { // Railing_13->Railing 9
    Railing_9
    rotate -180.0*z
  }
  object { // Railing_12->Railing 9
    Railing_9
    rotate -135.0*z
  }
  object { // Railing_11->Railing 9
    Railing_9
    rotate -90.0*z
  }
  object { // Railing_10->Railing 9
    Railing_9
    rotate -45.0*z
  }
  object { UserDefGroup2 }
  object { Railing_9 }
  translate  -6.3*z
}
#declare Object3_Ref = object {
  Object1
}
#declare Object4_Ref = object {
  Object2
  material {
    Fence_1
  }
}
#declare Top_Floor = union {
  object { Object3_Ref }
  object { Object4_Ref }
  material {
    White
  }
  scale <1.15, 1.15, 1.0>
  translate  18.75*z
}
#declare Object5_Ref = object {
  Object1
}
#declare Object6_Ref = object {
  Object2
  material {
    Fence_1
  }
}
#declare Top_Floor1 = union {
  object { Object5_Ref }
  object { Object6_Ref }
  material {
    White
  }
  scale <1.15, 1.15, 1.0>
}
#declare Floor_4 = union {
  object { // CSG009->Girders1
    Girders1
    rotate 45.0*z
  }
  object { // CSG010->Girders1
    Girders1
    rotate 90.0*z
  }
  object { // CSG011->Girders1
    Girders1
    rotate 135.0*z
  }
  object { // CSG012->Girders1
    Girders1
    rotate -180.0*z
  }
  object { // CSG013->Girders1
    Girders1
    rotate -135.0*z
  }
  object { // CSG014->Girders1
    Girders1
    rotate -90.0*z
  }
  object { // CSG015->Girders1
    Girders1
    rotate -45.0*z
  }
  object { Girders1 }
  object { Top_Floor1 }
  translate  -56.2*z
}
#declare Scafolding = union {
  object { // Group029->Tilty Girder Group
    Tilty_Girder_Group
    rotate 45.0*z
  }
  object { // Group030->Tilty Girder Group
    Tilty_Girder_Group
    rotate 90.0*z
  }
  object { // Group031->Tilty Girder Group
    Tilty_Girder_Group
    rotate 135.0*z
  }
  object { // Group032->Tilty Girder Group
    Tilty_Girder_Group
    rotate -180.0*z
  }
  object { // Group033->Tilty Girder Group
    Tilty_Girder_Group
    rotate -135.0*z
  }
  object { // Group034->Tilty Girder Group
    Tilty_Girder_Group
    rotate -90.0*z
  }
  object { // Group035->Tilty Girder Group
    Tilty_Girder_Group
    rotate -45.0*z
  }
  object { Tilty_Girder_Group }
  object { Star_Girders }
  object { Bottom_Floor }
  object { // Floor_3->Floor 1
    Floor_1
    translate  -37.5*z
  }
  object { // Floor_2->Floor 1
    Floor_1
    translate  -18.75*z
  }
  object { Floor_1 }
  object { Top_Floor }
  object { Floor_4 }
}
#declare Cooling_Tower = union {
  object { // Cylndr065->Cylndr071
    Cylndr071
    material {
      Red_Stripe
    }
    scale <1.0, 1.0, 0.8>
    translate  -54.2*z
  }
  object { // Cylndr066->Cylndr071
    Cylndr071
    material {
      White_Stripe
    }
    translate  -46.75*z
  }
  object { // Cylndr067->Cylndr071
    Cylndr071
    material {
      Red_Stripe
    }
    translate  -37.4*z
  }
  object { // Cylndr068->Cylndr071
    Cylndr071
    material {
      White_Stripe
    }
    translate  -28.05*z
  }
  object { // Cylndr069->Cylndr071
    Cylndr071
    material {
      Red_Stripe
      scale 8.0
      translate <0.000000, -0.050000, -1.350000>
    }
    translate  -18.7*z
  }
  object { // Cylndr070->Cylndr071
    Cylndr071
    material {
      White_Stripe
      scale 8.0
      translate <0.000000, -0.050000, 8.050000>
    }
    translate  -9.5*z
  }
  object { Cylndr071 }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Stripe
      translate <-0.100000, 0.000000, 0.000000>
    }
    scale <7.5, 7.5, 9.3>
    translate  9.35*z
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      White
      translate <-0.100000, 0.000000, 0.000000>
    }
    scale <7.5, 7.5, 2.5>
    translate  18.65*z
  }
  object { // Cylndr074->Cylndr071
    Cylndr071
    material {
      White_Stripe
    }
    scale <1.0, 1.0, 3.0>
    translate  -82.3*z
  }
  object { // Cylndr075->Cylndr071
    Cylndr071
    material {
      Red_Stripe
    }
    translate  -91.6*z
  }
  object { // Cylndr076->Cylndr071
    Cylndr071
    material {
      White_Stripe
    }
    translate  -101.0*z
  }
}
union { // Tower_and_Scaffolding
  object { Scafolding }
  object { Cooling_Tower }
  scale 0.2
  translate  <-5.05, 19.9, 34.75>
}


#declare wing1 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-5.687374, -2.522999, 0.000000>, <-2.510238, -1.450379, 0.000000>, <-1.483299, 1.141567, 2.274808>, <4.201373, -1.823581, 0.000000>, 
      <-5.687374, -2.504271, 0.000000>, <-2.510238, -1.102460, 0.000000>, <-1.483299, 1.658208, 2.274808>, <4.201373, -1.006652, 0.000000>, 
      <-5.687374, -2.485543, 0.000000>, <-2.510238, -0.754540, 0.000000>, <-1.551237, 2.287173, 2.274808>, <4.201373, -0.189722, 0.000000>, 
      <-5.687374, -2.466814, 0.000000>, <-2.510238, -0.406620, 0.000000>, <-1.551237, 2.803814, 2.274808>, <4.201373, 0.872364, 0.000000>
    }
  }
  translate  <-4.846532, -0.026935, 0.050722>
}
#declare wing2 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-5.687374, -2.522999, 0.000000>, <-2.510238, -1.450379, 0.000000>, <-1.582431, 1.141567, -2.582689>, <4.201373, -1.823581, 0.000000>, 
      <-5.687374, -2.504271, 0.000000>, <-2.510238, -1.102460, 0.000000>, <-1.582431, 1.658208, -2.582689>, <4.201373, -1.006652, 0.000000>, 
      <-5.687374, -2.485543, 0.000000>, <-2.510238, -0.754540, 0.000000>, <-1.650370, 2.287173, -2.582689>, <4.201373, -0.189722, 0.000000>, 
      <-5.687374, -2.466814, 0.000000>, <-2.510238, -0.406620, 0.000000>, <-1.650370, 2.803814, -2.582689>, <4.217705, 0.839752, 0.000000>
    }
  }
  rotate -180.0*y
  translate  <4.819196, -0.097501, 0.050722>
}
#declare tail1 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-3.532002, -2.398694, 0.000000>, <-0.587449, -1.171057, 0.000000>, <-0.531010, -1.171057, 0.000000>, <2.192664, -2.398694, 0.000000>, 
      <-2.718156, -1.056573, 0.000000>, <-0.578042, -1.053601, 0.000000>, <-0.536268, -1.053601, 0.000000>, <1.519077, -1.056573, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-0.603598, -1.154566, 0.000000>, <-0.539423, -1.154566, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-0.797608, 1.138490, 0.000000>, <-0.541025, 1.138490, 0.000000>, <-0.284442, 1.138490, 0.000000>, <-0.027860, 1.138490, 0.000000>
    }
  }
  scale <0.6, 0.55, 1.0>
  translate  <0.2, -3.0, 0.0>
}
union { // seabird1
  object { wing1 }
  object { wing2 }
  sphere { // birdbody
    <0,0,0>,1
    scale <1.0, 2.0, 0.5>
    translate  <-0.017198, -0.593076, 0.0>
  }
  sphere { // birdhead1
    <0,0,0>,1
    scale <0.5, 0.65, 0.35>
    translate  1.75*y
  }
  cone { // beak1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.1, 1.5>
    rotate 90.0*x
    translate  3.792165*y
  }
  object { tail1 }
  material {
    birdtex
  }
  scale 0.1
  translate  <37.55, 7.45, 60.55>
}


#declare wing3 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-5.687374, -2.522999, 0.000000>, <-2.510238, -1.450379, 0.000000>, <-1.483299, 1.141567, 2.274808>, <4.201373, -1.823581, 0.000000>, 
      <-5.687374, -2.504271, 0.000000>, <-2.510238, -1.102460, 0.000000>, <-1.483299, 1.658208, 2.274808>, <4.201373, -1.006652, 0.000000>, 
      <-5.687374, -2.485543, 0.000000>, <-2.510238, -0.754540, 0.000000>, <-1.551237, 2.287173, 2.274808>, <4.201373, -0.189722, 0.000000>, 
      <-5.687374, -2.466814, 0.000000>, <-2.510238, -0.406620, 0.000000>, <-1.551237, 2.803814, 2.274808>, <4.201373, 0.872364, 0.000000>
    }
  }
  translate  <-4.846532, -0.026935, 0.050722>
}
#declare wing4 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-5.687374, -2.522999, 0.000000>, <-2.510238, -1.450379, 0.000000>, <-1.582431, 1.141567, -2.582689>, <4.201373, -1.823581, 0.000000>, 
      <-5.687374, -2.504271, 0.000000>, <-2.510238, -1.102460, 0.000000>, <-1.582431, 1.658208, -2.582689>, <4.201373, -1.006652, 0.000000>, 
      <-5.687374, -2.485543, 0.000000>, <-2.510238, -0.754540, 0.000000>, <-1.650370, 2.287173, -2.582689>, <4.201373, -0.189722, 0.000000>, 
      <-5.687374, -2.466814, 0.000000>, <-2.510238, -0.406620, 0.000000>, <-1.650370, 2.803814, -2.582689>, <4.217705, 0.839752, 0.000000>
    }
  }
  rotate -180.0*y
  translate  <4.819196, -0.097501, 0.050722>
}
#declare tail2 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-3.532002, -2.398694, 0.000000>, <-0.587449, -1.171057, 0.000000>, <-0.531010, -1.171057, 0.000000>, <2.192664, -2.398694, 0.000000>, 
      <-2.718156, -1.056573, 0.000000>, <-0.578042, -1.053601, 0.000000>, <-0.536268, -1.053601, 0.000000>, <1.519077, -1.056573, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-0.603598, -1.154566, 0.000000>, <-0.539423, -1.154566, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-0.797608, 1.138490, 0.000000>, <-0.541025, 1.138490, 0.000000>, <-0.284442, 1.138490, 0.000000>, <-0.027860, 1.138490, 0.000000>
    }
  }
  scale <0.6, 0.55, 1.0>
  translate  <0.2, -3.0, 0.0>
}
union { // seabird2
  object { wing3 }
  object { wing4 }
  sphere { // birdbody1
    <0,0,0>,1
    scale <1.0, 2.0, 0.5>
    translate  <-0.017198, -0.593076, 0.0>
  }
  sphere { // birdhead2
    <0,0,0>,1
    scale <0.5, 0.65, 0.35>
    translate  1.75*y
  }
  cone { // beak2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.1, 1.5>
    rotate 90.0*x
    translate  3.792165*y
  }
  object { tail2 }
  material {
    birdtex
  }
  scale 0.1
  rotate 58.0*z
  translate  <29.4, 7.45, 66.9>
}


#declare wing5 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-5.687374, -2.522999, 0.000000>, <-2.510238, -1.450379, 0.000000>, <-1.483299, 1.141567, 2.274808>, <4.201373, -1.823581, 0.000000>, 
      <-5.687374, -2.504271, 0.000000>, <-2.510238, -1.102460, 0.000000>, <-1.483299, 1.658208, 2.274808>, <4.201373, -1.006652, 0.000000>, 
      <-5.687374, -2.485543, 0.000000>, <-2.510238, -0.754540, 0.000000>, <-1.551237, 2.287173, 2.274808>, <4.201373, -0.189722, 0.000000>, 
      <-5.687374, -2.466814, 0.000000>, <-2.510238, -0.406620, 0.000000>, <-1.551237, 2.803814, 2.274808>, <4.201373, 0.872364, 0.000000>
    }
  }
  translate  <-4.846532, -0.026935, 0.050722>
}
#declare wing6 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-5.687374, -2.522999, 0.000000>, <-2.510238, -1.450379, 0.000000>, <-1.582431, 1.141567, -2.582689>, <4.201373, -1.823581, 0.000000>, 
      <-5.687374, -2.504271, 0.000000>, <-2.510238, -1.102460, 0.000000>, <-1.582431, 1.658208, -2.582689>, <4.201373, -1.006652, 0.000000>, 
      <-5.687374, -2.485543, 0.000000>, <-2.510238, -0.754540, 0.000000>, <-1.650370, 2.287173, -2.582689>, <4.201373, -0.189722, 0.000000>, 
      <-5.687374, -2.466814, 0.000000>, <-2.510238, -0.406620, 0.000000>, <-1.650370, 2.803814, -2.582689>, <4.217705, 0.839752, 0.000000>
    }
  }
  rotate -180.0*y
  translate  <4.819196, -0.097501, 0.050722>
}
#declare tail3 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-3.532002, -2.398694, 0.000000>, <-0.587449, -1.171057, 0.000000>, <-0.531010, -1.171057, 0.000000>, <2.192664, -2.398694, 0.000000>, 
      <-2.718156, -1.056573, 0.000000>, <-0.578042, -1.053601, 0.000000>, <-0.536268, -1.053601, 0.000000>, <1.519077, -1.056573, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-0.603598, -1.154566, 0.000000>, <-0.539423, -1.154566, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-0.797608, 1.138490, 0.000000>, <-0.541025, 1.138490, 0.000000>, <-0.284442, 1.138490, 0.000000>, <-0.027860, 1.138490, 0.000000>
    }
  }
  scale <0.6, 0.55, 1.0>
  translate  <0.2, -3.0, 0.0>
}
union { // seabird3
  object { wing5 }
  object { wing6 }
  sphere { // birdbody2
    <0,0,0>,1
    scale <1.0, 2.0, 0.5>
    translate  <-0.017198, -0.593076, 0.0>
  }
  sphere { // birdhead3
    <0,0,0>,1
    scale <0.5, 0.65, 0.35>
    translate  1.75*y
  }
  cone { // beak3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.1, 1.5>
    rotate 90.0*x
    translate  3.792165*y
  }
  object { tail3 }
  material {
    birdtex
  }
  scale 0.1
  rotate <-0.0, 0.0, 107.0>
  translate  <37.2, 15.4, 82.35>
}


